{********************************************
; File: Loader.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT LOADER;
INTERFACE
USES TYPES;
CONST


{ Error Codes }
idNotFound = $1101;  { segment/application/entry not found }
idPathnameErr = $1103;
idNotLoadFile = $1104;  { file is not a load file }
idBusyErr = $1105;  { system loader is busy }
idFilVersErr = $1107;  { file version error }
idUserIDErr = $1108;  { user ID error }
idSequenceErr = $1109;  { segnum out of sequence }
idBadRecordErr = $110A;  { illegal load record found }
idForeignSegErr = $110B;  { segment is foreign }
TYPE
InitialLoadOutputRecPtr = ^InitialLoadOutputRec;
InitialLoadOutputRec = RECORD
    userID : Integer;
    startAddr : Ptr;
    dPageAddr : Integer;
    buffSize : Integer;
END;
RestartOutRecPtr = ^RestartOutRec;
RestartOutRec = RECORD
    userID : Integer;
    startAddr : Ptr;
    dPageAddr : Integer;
    buffSize : Integer;
END;
LoadSegNameOutPtr = ^LoadSegNameOut;
LoadSegNameOut = RECORD
    segAddr : Ptr;
    userID : Integer;
    fileNum : Integer;
    segNum : Integer;
END;
UnloadSegOutRecPtr = ^UnloadSegOutRec;
UnloadSegOutRec = RECORD
    userID : Integer;
    fileNum : Integer;
    segNum : Integer;
END;
PROCEDURE GetLoadSegInfo ( userID:Integer; loadFileNum:Integer; loadSegNum:Integer; bufferPtr:Ptr)  ;
FUNCTION GetPathname ( userID:Integer; fileNumber:Integer) : Ptr ;
FUNCTION GetPathname2 ( userID:Integer; fileNumber:Integer) : Ptr ;
FUNCTION GetUserID ( pathNamePtr:Ptr) : Integer ;
FUNCTION GetUserID2 ( pathNamePtr:Ptr) : Integer ;
FUNCTION InitialLoad ( userID:Integer; loadFileNamePtr:Ptr; spMemFlag:Boolean) : InitialLoadOutputRec ;
FUNCTION InitialLoad2 ( userID:Integer; loadFileNamePtr:Ptr; spMemFlag:Boolean; inputType:Integer) : InitialLoadOutputRec ;
FUNCTION LGetPathname ( userID:Integer; fileNumber:Integer) : Ptr ;
FUNCTION LGetPathname2 ( userID:Integer; fileNumber:Integer) : Ptr ;
PROCEDURE LoaderInitialization   ;
PROCEDURE LoaderReset   ;
PROCEDURE LoaderShutDown   ;
PROCEDURE LoaderStartUp   ;
FUNCTION LoaderStatus  : Boolean ;
FUNCTION LoaderVersion  : Integer ;
FUNCTION LoadSegName ( userID:Integer; loadFileNamePtr:Ptr; loadSegNamePtr:Ptr) : LoadSegNameOut ;
FUNCTION LoadSegNum ( userID:Integer; loadFileNum:Integer; loadSegNum:Integer) : Ptr ;
PROCEDURE RenamePathname ( oldPathname:Ptr; newPathname:Ptr)  ;
FUNCTION Restart ( userID:Integer) : RestartOutRec ;
FUNCTION UnloadSeg ( segmentPtr:Ptr) : UnloadSegOutRec ;
PROCEDURE UnloadSegNum ( userID:Integer; loadFileNum:Integer; loadSegNum:Integer)  ;
FUNCTION UserShutDown ( userID:Integer; restartFlag:Integer) : Integer ;
IMPLEMENTATION
END.
